/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cmsc420project4;

/**
 *
 * @author Jeremiah
 */
public class SheetArray {
    private Cell[][] cells;

    // Since the nodes essentially represent cells, store them with the cells
    // so it's easier to figure the dependencies.
    private DirectedNode[][] myNode;

    // Computed results
    private String[][] original;
    private String[][] results;

    SheetArray()
    {
        cells = new Cell[10][10];
        original = new String[10][10];
        results = new String[10][10];
        myNode = new DirectedNode[10][10];
        for(int x=0; x<10; x++)
            {
            for(int y=0; y<10; y++)
                {
                original[x][y]="";
                results[x][y]="";
            }
        }
    }

    public void setCell(int x, int y, Cell data)
    {
        if(x>=0 && x<10 && y>=0 && y<10)
        {
            cells[x][y]=data;
        } else {
            throw new RuntimeException("Invalid cell position.");
        }
    }

    public Cell getCell(int x, int y)
    {
        if(x>=0 && x<10 && y>=0 && y<10)
        {
            return cells[x][y];
        } else {
            throw new RuntimeException("Invalid cell position.");
        }
    }

    public void setOriginal(int x, int y, String result)
            {
        original[x][y] = result;
    }

    public String getOriginal(int x, int y)
            {
        return original[x][y];
    }

    public void setResult(int x, int y, String result)
            {
        results[x][y] = result;
    }

    public String getResult(int x, int y)
            {
        return results[x][y];
    }

    public void setNode(int x, int y, DirectedNode node)
            {
        myNode[x][y] = node;
    }

    public DirectedNode getNode(int x, int y)
            {
        return myNode[x][y];
    }
}
